/* Copyright (c) 2008, 2012, Oracle and/or its affiliates. 
All rights reserved. */

import java.io.*;
import java.sql.*;
import oracle.sql.*;

public class LAS {
        String fileName;
        String tableTableSpace;
        String indexTableSpace;
        String indexWorkTableSpace;

        FileInputStream inputStream;
        BufferedInputStream bufferin;
        boolean cancelStatus = false;
        String srid;

        String connectionString;

        long numberOfVariableLengthRecords;
        long numberOfPointRecords;
        int pointDataFormatID;
        int pointDataRecordLength;

        String tableName;

        protected static Connection connection;

        public LAS(String fileName,
                   String computerName,
                   String databaseName,
                   String portNumber,
                   String schemaName,
                   String password,
                   String tableName,
                   String tableTableSpace,
                   String indexTableSpace,
                   String indexWorkTableSpace,
                   String srid){
          this.fileName=fileName;
          this.connectionString =
          "jdbc:oracle:thin:@(DESCRIPTION=" +
          "(ADDRESS_LIST=(ADDRESS=(HOST="+computerName+")(PROTOCOL=tcp)(PORT="+portNumber+")))" +
          "(CONNECT_DATA=(SID="+databaseName+")))";

          this.tableName=tableName;
          this.srid=srid;
          this.tableTableSpace=tableTableSpace;
          this.indexTableSpace=indexTableSpace;
          this.indexWorkTableSpace=indexWorkTableSpace;
          if (this.tableTableSpace.equals("")) 
            this.tableTableSpace=null;
          if (this.indexTableSpace.equals("")) 
            this.indexTableSpace=null;
          if (this.indexWorkTableSpace.equals("")) 
            this.indexWorkTableSpace=null;
          try {
            System.out.println("***CONNECTION STRING: "+this.connectionString);
            DriverManager.registerDriver(new oracle.jdbc.OracleDriver());
            connection = DriverManager.getConnection(this.connectionString, schemaName, password);

            try { connection.setAutoCommit(false); }
            catch (SQLException exception) { exception.printStackTrace(); }

          }
          catch (SQLException e) { 
            e.printStackTrace();
          }
        }


	public void cancel(){
	  cancelStatus = true;
	}

	public void readHeaderOnly(){
	  try {
	    inputStream = new FileInputStream(fileName);
	    bufferin = new BufferedInputStream(inputStream,10000);
	  }
          catch (FileNotFoundException exception) {
	    exception.printStackTrace();
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
	  }
	  parseHeader();
	  try {
	    bufferin.close();
	    inputStream.close();
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
	  }
	}

	public LASHeader parseHeader(){
	  LASHeader lasHeader = new LASHeader();
	  lasHeader.parse(bufferin);

	  numberOfPointRecords = lasHeader.getNumberOfPointRecords();
	  numberOfVariableLengthRecords = lasHeader.getNumberOfVariableLengthRecords();
	  pointDataRecordLength = lasHeader.getPointDataRecordLength();
	  pointDataFormatID = lasHeader.getPointDataFormatID();
	  return lasHeader;
	}

	public LASVariableLengthRecord parseVariableLengthRecord(){
	  LASVariableLengthRecord lasVariableLengthRecord = new LASVariableLengthRecord();
	  lasVariableLengthRecord.parse(bufferin);
          return lasVariableLengthRecord;
	}

	public LASPointDataRecord parsePointDataRecord(){
	  LASPointDataRecord lasPointDataRecord = LASPointDataRecord.createPointDataRecord(pointDataFormatID);
	  lasPointDataRecord.parse(bufferin,pointDataRecordLength);
          return lasPointDataRecord;
	}

	public void read() throws IOException, Exception{
	  try {
	    inputStream = new FileInputStream(fileName);
	    bufferin = new BufferedInputStream(inputStream,10000);
	  }
          catch (FileNotFoundException exception) {
	    exception.printStackTrace();
	  }
          catch(IOException exception){
	    exception.printStackTrace();
	  }

	  LASHeader lasHeader = parseHeader();
	  lasHeader.print();
	  System.out.println();

	  for (int a = 0; a < numberOfVariableLengthRecords; a++) {
	    LASVariableLengthRecord lasVariableLengthRecord = parseVariableLengthRecord();
	    lasVariableLengthRecord.print();
	    lasVariableLengthRecord.parseGeoreferencingInformation();
	    System.out.println();
	  }

	  System.out.println();
	  LASPointDataRecord.readStartSignature(bufferin);
	  for (int b = 0; b < numberOfPointRecords; b++) {
	    LASPointDataRecord lasPointDataRecord = parsePointDataRecord();
	    lasPointDataRecord.print();
	    System.out.println();
	  }

	  try {
	    bufferin.close();
	    inputStream.close();
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
	  }
	}

  /*--------------------------------------------------------------------------*/
  /*                               LAS 1.1 Support                            */
  /*                    Converting LiDAR data to SDO_GEOMETRY                 */
  /*--------------------------------------------------------------------------*/

	public void oracleImport() throws SQLException, IOException, Exception {
          try {
	    inputStream = new FileInputStream(fileName);
	    bufferin = new BufferedInputStream(inputStream, 10000);
	  } 
          catch (FileNotFoundException exception) {
	    exception.printStackTrace();
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
	  }

	  LASHeader lasHeader = parseHeader();

          //Statement stmt = connection.createStatement();
          //ResultSet typeCheckSQLResult = 
          //stmt.executeQuery("select type_name from user_types where type_name='POINT_DATA_RECORD_OBJECT'");
          //if (!typeCheckSQLResult.next())
	    //createObjects(connection);
	  //typeCheckSQLResult.close();

          Statement stmt = connection.createStatement();
          ResultSet tableCheckSQLResult = 
          stmt.executeQuery("select table_name from user_tables where table_name='"+ 
          tableName.toUpperCase() +"'");
	  if (!tableCheckSQLResult.next())
            createTable(connection);
	  tableCheckSQLResult.close();
    
	  Statement stmt_vlr = connection.createStatement();
	  ResultSet tableCheckSQLResult_vlr = 
	  stmt_vlr.executeQuery("select table_name from user_tables where table_name='"+ 
	  "variable_length_records".toUpperCase() +"'");
	  if (!tableCheckSQLResult_vlr.next())
	    createTable_vlr(connection);
	  tableCheckSQLResult_vlr.close();
    
	  Statement stmt_pdr = connection.createStatement();
	  ResultSet tableCheckSQLResult_pdr = 
	  stmt_pdr.executeQuery("select table_name from user_tables where table_name='"+ 
	  "point_data_records".toUpperCase() +"'");
	  if (!tableCheckSQLResult_pdr.next())
	    createTable_pdr(connection);
	  tableCheckSQLResult_pdr.close();
	  

          stmt = connection.createStatement();
	  ResultSet sequenceSqlResult = 
          stmt.executeQuery("select S_"+tableName+".nextval from dual");
          int recordID;
          if (sequenceSqlResult.next())
            recordID = sequenceSqlResult.getInt(1);
          else {
            System.out.println("Database not set up properly");
            return;
          }
          sequenceSqlResult.close();

          double minX=lasHeader.getMinX();
          double maxX=lasHeader.getMaxX();
          double minY=lasHeader.getMinY();
          double maxY=lasHeader.getMaxY();

	  if (srid == "")
            srid = "NULL";

          Statement stmt2 = connection.createStatement();
          stmt2.executeUpdate("insert /*+append*/ into "+ tableName +" ("+
                           "id,"+
			   "source_file_name,"+
			   "coverage_geometry,"+
			   "file_signature,"+
			   "reserved,"+
			   "guid_data_1,"+
			   "guid_data_2,"+
			   "guid_data_3,"+
			   "guid_data_4,"+
			   "version_major,"+
			   "version_minor,"+
			   "system_identifier,"+
			   "generating_software,"+
			   "flight_julian_date,"+
			   "year,"+
			   "header_size,"+
			   "offset_to_data,"+
			   "number_variable_length_records,"+
			   "point_data_format_id,"+
			   "point_data_record_length,"+
			   "number_of_point_records,"+
			   "number_of_points_by_return_1,"+
			   "number_of_points_by_return_2,"+
			   "number_of_points_by_return_3,"+
			   "number_of_points_by_return_4,"+
			   "number_of_points_by_return_5,"+
			   "x_scale_factor,"+
			   "y_scale_factor,"+
			   "z_scale_factor,"+
			   "x_offset,"+
			   "y_offset,"+
			   "z_offset,"+
			   "max_x,"+
			   "min_x,"+
			   "max_y,"+
			   "min_y,"+
			   "max_z,"+
			   "min_z,"+
			   //"variable_length_records,"+
			   //"point_data_records,"+
			   "extra_data"+
			   ") VALUES ("+
			   recordID+","+
			   "'"+fileName+"',"+
			   "SDO_GEOMETRY(2003,"+srid+",NULL,SDO_ELEM_INFO_ARRAY(1,1003,1),SDO_ORDINATE_ARRAY("+minX+","+minY+","+   +maxX+","+minY+","+  +maxX+","+maxY+","+  +minX+","+maxY+","+   +minX+","+minY+")),"+
			   "'"+lasHeader.getFileSignature()+"',"+
			   lasHeader.getReserved()+","+
			   lasHeader.getGuidData1()+","+
			   lasHeader.getGuidData2()+","+
			   lasHeader.getGuidData3()+","+
			   "'"+lasHeader.getGuidData4()+"',"+
			   lasHeader.getVersionMajor()+","+
			   lasHeader.getVersionMinor()+","+
			   "'"+lasHeader.getSystemIdentifier()+"',"+
			   "'"+lasHeader.getGeneratingSoftware()+"',"+
			   lasHeader.getFlightJulianDate()+","+
			   lasHeader.getYear()+","+
			   lasHeader.getHeaderSize()+","+
			   lasHeader.getOffsetToData()+","+
			   lasHeader.getNumberOfVariableLengthRecords()+","+
			   lasHeader.getPointDataFormatID()+","+
			   lasHeader.getPointDataRecordLength()+","+
			   lasHeader.getNumberOfPointRecords()+","+
			   lasHeader.getNumberOfPointsByReturn1()+","+
			   lasHeader.getNumberOfPointsByReturn2()+","+
			   lasHeader.getNumberOfPointsByReturn3()+","+
			   lasHeader.getNumberOfPointsByReturn4()+","+
			   lasHeader.getNumberOfPointsByReturn5()+","+
			   lasHeader.getXScaleFactor()+","+
			   lasHeader.getYScaleFactor()+","+
			   lasHeader.getZScaleFactor()+","+
			   lasHeader.getXOffset()+","+
			   lasHeader.getYOffset()+","+
			   lasHeader.getZOffset()+","+
			   lasHeader.getMaxX()+","+
			   lasHeader.getMinX()+","+
			   lasHeader.getMaxY()+","+
			   lasHeader.getMinY()+","+
			   lasHeader.getMaxZ()+","+
			   lasHeader.getMinZ()+","+
			   //"variable_length_record_table(),"+
			   //"point_data_record_table(),"+
			   "empty_blob()"+
			   ")"
			  );

	  if ((lasHeader.getExtraData() != null) &&
              (lasHeader.getExtraData().length > 0)) {
	    OutputStream outputStream = null;
	    Statement statement = null;
	    oracle.jdbc.OracleResultSet result = null;

	    try {
	      statement = connection.createStatement();

              result = (oracle.jdbc.OracleResultSet)statement.executeQuery(
              "SELECT extra_data FROM "+ tableName +" WHERE id="+ recordID +" FOR UPDATE");
	      result.next();
	      BLOB blob = result.getBLOB(1);
	      outputStream = blob.setBinaryStream(1);//07.27.2009- Not 0L.

	      outputStream.write(lasHeader.getExtraData(),0,lasHeader.getExtraData().length);
              result.close();
              statement.close();
              connection.commit();
            }
            catch (Exception exception) {
              exception.printStackTrace();
            }
            finally {
              try {
                outputStream.close();
              }
              catch (IOException ex3) {
                throw ex3;
              }
              try {
                result.close();
              }
              catch (SQLException ex2) {
                throw ex2;
              }
              try {
                statement.close();
              }
              catch (SQLException ex1) {
                throw ex1;
              }
	      try {
                connection.commit();
              }
              catch (SQLException ex) {
                throw ex;
              }
            }
	  }

          LASVariableLengthRecord lasVariableLengthRecord = new LASVariableLengthRecord();
          for (int a = 0; a < numberOfVariableLengthRecords; a++) {
	    lasVariableLengthRecord.parse(bufferin);
            Statement stmt3 = connection.createStatement();
            //stmt3.executeUpdate("insert /*+append*/ into TABLE(select a.variable_length_records from "+ tableName +" a where a.id = "+ recordID +") "+
            stmt3.executeUpdate("insert /*+append*/ into variable_length_records "+
				"("+
	      "vlr_id,"+
				"fk_id,"+
				"record_signature,"+
				"user_id,"+
				"record_id,"+
				"record_length_after_header,"+
				"description,"+
				"data"+
				") VALUES("+
				a+","+
        recordID+","+
				lasVariableLengthRecord.getRecordSignature()+","+
				"'"+lasVariableLengthRecord.getUserID()+"',"+
				lasVariableLengthRecord.getRecordID()+","+
				lasVariableLengthRecord.getRecordLengthAfterHeader()+","+
				"'"+lasVariableLengthRecord.getDescription()+"',"+
				"empty_blob()"+
				")"
	    );

            if (lasVariableLengthRecord.getData() != null) {
	      OutputStream outputStream = null;
	      //Connection connection = null;
	      Statement statement = null;
	      oracle.jdbc.OracleResultSet result = null;
	      try {
	        //connection = DriverManager.getConnection("jdbc:default:connection:");
	        statement = connection.createStatement();
	        result = (oracle.jdbc.OracleResultSet)
                
                //statement.executeQuery("SELECT data FROM TABLE(select a.variable_length_records from "+
                //tableName +" a where a.id = "+ recordID +") WHERE id="+ a +" FOR UPDATE");
                statement.executeQuery("SELECT data FROM variable_length_records a where a.fk_id = "+ recordID +"and a.vlr_id="+ a +" FOR UPDATE");
                
	        if (result.next()) {
	          BLOB blob = result.getBLOB(1);
	          outputStream = blob.setBinaryStream(1);//07.27.2009- Not 0L.
                  //System.out.println(lasVariableLengthRecord.arrayToBits(lasVariableLengthRecord.getData()));
	          outputStream.write(lasVariableLengthRecord.getData(),0,lasVariableLengthRecord.getData().length);
	        }
                else {
        	  System.out.println("failed to get blob");
		}
	      }
              catch (Exception exception){
	        exception.printStackTrace();
	      }
              finally {
	        try {
                  outputStream.close();
                } 
                catch (IOException ex3) { 
                  ex3.printStackTrace();
                }
	        try {
                  result.close();
                }
                catch (SQLException ex2) { 
                  ex2.printStackTrace();
                }
		try {
                  statement.close();
                }
                catch (SQLException ex1) { 
                  ex1.printStackTrace();
                }
		try {
                  connection.commit();
                } 
                catch (SQLException ex) {
                  ex.printStackTrace();
                }
		//connection.close();
	      }
            }
	  }

	  LASPointDataRecord.readStartSignature(bufferin);

	  try {
	    connection.setAutoCommit(false);
          }
          catch (SQLException exception) {
	    exception.printStackTrace();
	  }
	  LASPointDataRecord lasPointDataRecord=LASPointDataRecord.createPointDataRecord(pointDataFormatID);

	  StructDescriptor sdoGeometryDescriptor = null;
	  StructDescriptor sdoPointTypeDescriptor = null;
	  PreparedStatement insertPreparedStatement = null;
	  try {
	    sdoGeometryDescriptor = StructDescriptor.createDescriptor("MDSYS.SDO_GEOMETRY",connection);
	    sdoPointTypeDescriptor = StructDescriptor.createDescriptor("MDSYS.SDO_POINT_TYPE",connection);
	    insertPreparedStatement = connection.prepareStatement(
	    //"insert /*+append*/ into TABLE(select a.point_data_records from "+ tableName +" a where a.id = "+recordID+") "+
	    "insert /*+append*/ into point_data_records "+
	    "("+
      "pdr_id,"+
	    "fk_id,"+
	    "point_geometry,"+
	    "pulse_number,"+
	    "x,"+
	    "y,"+
	    "z,"+
	    "intensity,"+
	    "return_number,"+
	    "number_of_returns,"+
	    "scan_direction_flag,"+
	    "edge_of_flight_line,"+
	    "classification,"+
	    "scan_angle_rank,"+
	    "file_marker,"+
	    "user_bit_field,"+
	    (String)((lasPointDataRecord instanceof LASPointDataRecordFormat1)?("gps_time,"):(""))+
	    "extra_data"+
	    ") VALUES("+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    "?,"+
	    (String)((lasPointDataRecord instanceof LASPointDataRecordFormat1)?("?,"):(""))+
	    "empty_blob()"+
            //"?"+  // goes with the RAW stuff below   delete that and you have to delete this
	    ")"
	    );
      //	    ((oracle.jdbc.OraclePreparedStatement)insertPreparedStatement).setExecuteBatch(500);
	  }
          catch (SQLException exception) {
            exception.printStackTrace();
	  }

	  double x, y, z;
   	  Object[] sdoPointTypeAttributes = new Object[3];
	  Object[] sdoGeometryAttributes = new Object[5];
	  STRUCT sdoGeometry; 
          
	  if (lasPointDataRecord instanceof LASPointDataRecordFormat0){
	    for (int b = 0, pulseNumber = 0,commitCounter = 0;
                 b < numberOfPointRecords && !cancelStatus;
                 b++, commitCounter++) {
	      try {
		lasPointDataRecord.parse(bufferin,pointDataRecordLength);
		if (commitCounter == 5000) {
		  System.out.println(b);
      insertPreparedStatement.executeBatch();
		  connection.commit();
		  commitCounter=0;
		}
		if (lasPointDataRecord.getReturnNumber() == 1) {
		  pulseNumber++;
		}
		x = ((lasPointDataRecord.getX()*lasHeader.getXScaleFactor())+lasHeader.getXOffset());
		y = ((lasPointDataRecord.getY()*lasHeader.getYScaleFactor())+lasHeader.getYOffset());
		z = ((lasPointDataRecord.getZ()*lasHeader.getZScaleFactor())+lasHeader.getZOffset());

		sdoPointTypeAttributes[0] = new NUMBER(x);
		sdoPointTypeAttributes[1] = new NUMBER(y);
		sdoPointTypeAttributes[2] = new NUMBER(z);

		sdoGeometryAttributes[0] = new NUMBER(3001);

		try {
		  sdoGeometryAttributes[1] = new NUMBER(Integer.parseInt(srid));
		}
                catch (Exception exception) {
		  sdoGeometryAttributes[1] = null;
		}
		sdoGeometryAttributes[2] = new STRUCT(sdoPointTypeDescriptor,connection,sdoPointTypeAttributes);;
		sdoGeometryAttributes[3] = null;
		sdoGeometryAttributes[4] = null;
		sdoGeometry = new STRUCT(sdoGeometryDescriptor,connection,sdoGeometryAttributes);

		insertPreparedStatement.setInt(1,b);
	  insertPreparedStatement.setInt(2,recordID);
		insertPreparedStatement.setObject(3,sdoGeometry);
		insertPreparedStatement.setInt(4,pulseNumber);
		insertPreparedStatement.setInt(5,lasPointDataRecord.getX());
		insertPreparedStatement.setInt(6,lasPointDataRecord.getY());
		insertPreparedStatement.setInt(7,lasPointDataRecord.getZ());
		insertPreparedStatement.setInt(8,lasPointDataRecord.getIntensity());
		insertPreparedStatement.setInt(9,lasPointDataRecord.getReturnNumber());
		insertPreparedStatement.setInt(10,lasPointDataRecord.getNumberOfReturns());
		insertPreparedStatement.setInt(11,lasPointDataRecord.getScanDirectionFlag());
		insertPreparedStatement.setInt(12,lasPointDataRecord.getEdgeOfFlightLine());
		insertPreparedStatement.setInt(13,lasPointDataRecord.getClassification());
		insertPreparedStatement.setInt(14,lasPointDataRecord.getScanAngleRank());
		insertPreparedStatement.setLong(15,lasPointDataRecord.getFileMarker());
		insertPreparedStatement.setInt(16,lasPointDataRecord.getUserBitField());
                //insertPreparedStatement.setObject(17,new RAW(lasPointDataRecord.getExtraData()));//this might work for <4000 bytes of binary data
		insertPreparedStatement.addBatch();
	      }
              catch (SQLException exception) {
	        exception.printStackTrace();
	      }
	      ////----
	      /*
	      // this might slow everything very much; but it should ever hardly be called
	      // just included for completeness, but hasn't been tested 
	      if ((lasPointDataRecord.getExtraData() != null) &&
                  (lasPointDataRecord.getExtraData().length > 0)) {
		OutputStream outputStream=null;
		Statement statement=null;
		oracle.jdbc.OracleResultSet result=null;
		try {
		  connection.commit(); // may not be necessary
		  statement=connection.createStatement();

		  result=(oracle.jdbc.OracleResultSet)statement.executeQuery("SELECT extra_data FROM TABLE(select a.point_data_records from "+tableName+" a where a.id = "+recordID+") WHERE id="+b+" FOR UPDATE");
		  result.next();
		  BLOB blob=result.getBLOB(1);
		  outputStream=blob.setBinaryStream(1);//07.27.2009- Not 0L.
		  outputStream.write(lasPointDataRecord.getExtraData(),0,lasPointDataRecord.getExtraData().length);

		  result.close();
		  statement.close();
		}
                catch(Exception exception){
		  exception.printStackTrace();
		}
                finally {
		  try{outputStream.close();} catch(IOException ex3){}
		  try{result.close();} catch(SQLException ex2){}
		  try{statement.close();} catch(SQLException ex1){}
		  try{connection.commit();} catch(SQLException ex){}
		}
	      }
	      */
	      ////----
	    }
          }
          else if (lasPointDataRecord instanceof LASPointDataRecordFormat1){
	    for (int b = 0, pulseNumber = 0, commitCounter = 0; 
                 b < numberOfPointRecords && !cancelStatus; 
                 b++, commitCounter++) {
	      try {
		lasPointDataRecord.parse(bufferin,pointDataRecordLength);
		if (commitCounter == 5000) {
		  System.out.println(b);
      insertPreparedStatement.executeBatch();
		  connection.commit();
		  commitCounter=0;
		}
		if (lasPointDataRecord.getReturnNumber() == 1) {
		  pulseNumber++;
		}
		x = ((lasPointDataRecord.getX()*lasHeader.getXScaleFactor())+lasHeader.getXOffset());
		y = ((lasPointDataRecord.getY()*lasHeader.getYScaleFactor())+lasHeader.getYOffset());
		z = ((lasPointDataRecord.getZ()*lasHeader.getZScaleFactor())+lasHeader.getZOffset());

		sdoPointTypeAttributes[0] = new NUMBER(x);
		sdoPointTypeAttributes[1] = new NUMBER(y);
		sdoPointTypeAttributes[2] = new NUMBER(z);

		sdoGeometryAttributes[0] = new NUMBER(3001);
		try {
		  sdoGeometryAttributes[1] = new NUMBER(Integer.parseInt(srid));
		}
                catch (Exception exception) {
		  sdoGeometryAttributes[1] = null;
		}
		sdoGeometryAttributes[2] = new STRUCT(sdoPointTypeDescriptor,connection,sdoPointTypeAttributes);;
		sdoGeometryAttributes[3] = null;
		sdoGeometryAttributes[4] = null;
		sdoGeometry = new STRUCT(sdoGeometryDescriptor,connection,sdoGeometryAttributes);

		insertPreparedStatement.setInt(1,b);
	  insertPreparedStatement.setInt(2,recordID);
		insertPreparedStatement.setObject(3,sdoGeometry);
		insertPreparedStatement.setInt(4,pulseNumber);
		insertPreparedStatement.setInt(5,lasPointDataRecord.getX());
		insertPreparedStatement.setInt(6,lasPointDataRecord.getY());
		insertPreparedStatement.setInt(7,lasPointDataRecord.getZ());
		insertPreparedStatement.setInt(8,lasPointDataRecord.getIntensity());
		insertPreparedStatement.setInt(9,lasPointDataRecord.getReturnNumber());
		insertPreparedStatement.setInt(10,lasPointDataRecord.getNumberOfReturns());
		insertPreparedStatement.setInt(11,lasPointDataRecord.getScanDirectionFlag());
		insertPreparedStatement.setInt(12,lasPointDataRecord.getEdgeOfFlightLine());
		insertPreparedStatement.setInt(13,lasPointDataRecord.getClassification());
		insertPreparedStatement.setInt(14,lasPointDataRecord.getScanAngleRank());
		insertPreparedStatement.setLong(15,lasPointDataRecord.getFileMarker());
		insertPreparedStatement.setInt(16,lasPointDataRecord.getUserBitField());
		insertPreparedStatement.setDouble(17,((LASPointDataRecordFormat1)lasPointDataRecord).getGPSTime());
                //insertPreparedStatement.setObject(18,new RAW(lasPointDataRecord.getExtraData()));//this might work for <4000 bytes of binary data--- doesn't
		insertPreparedStatement.addBatch();
	      }
              catch (SQLException exception) {
	        exception.printStackTrace();
	      }
	    }
          }
	  try {
      insertPreparedStatement.executeBatch();
	    connection.commit();
	  }
          catch (SQLException exception) {
	    exception.printStackTrace();
	  }
          try {
	    insertPreparedStatement.close();
	  }
          catch (SQLException exception) {
	    exception.printStackTrace();
	  }
	  connection.close();
          try {
	    bufferin.close();
	    inputStream.close();
	  }
          catch (IOException exception) {
            exception.printStackTrace();
	  }
	}

  /**@deprecated
   */
	public void createObjects(Connection connection) throws Exception{
	  Statement statement = connection.createStatement();
	  statement.execute("create or replace type variable_length_record_object as object("+
                           "id number,"+
                           "record_signature number,"+
                           "user_id varchar(16),"+
                           "record_id number,"+
                           "record_length_after_header number,"+
                           "description varchar2(32),"+
                           "data blob"+
                           ")"
          );

          statement.execute("create type variable_length_record_table as table of variable_length_record_object");

          statement.execute("create or replace type point_data_record_object as object("+
			    "id number,"+
			    "point_geometry sdo_geometry,"+
			    "pulse_number number,"+
			    "x number,"+
			    "y number,"+
			    "z number,"+
			    "intensity number,"+
			    "return_number number,"+
			    "number_of_returns number,"+
			    "scan_direction_flag number,"+
			    "edge_of_flight_line number,"+
			    "classification number,"+
			    "scan_angle_rank number,"+
			    "file_marker number,"+
			    "user_bit_field number,"+
			    "gps_time number,"+
			    "extra_data blob"+
			    ")"
	  );

          statement.execute("create type point_data_record_table as table of point_data_record_object");
	}

	public void createTable(Connection connection) throws Exception {
	  Statement statement = connection.createStatement();
	  statement.execute("create sequence S_"+ tableName +" start with 1 increment by 1");

          statement.execute("create table "+ tableName +"("+
			    "id number,"+
			    "source_file_name varchar(1024),"+
			    "coverage_geometry sdo_geometry,"+
			    "file_signature varchar(4),"+
			    "reserved number,"+
			    "guid_data_1 number,"+
			    "guid_data_2 number,"+
			    "guid_data_3 number,"+
			    "guid_data_4 varchar2(8),"+
			    "version_major number,"+
			    "version_minor number,"+
			    "system_identifier varchar2(32),"+
			    "generating_software varchar2(32),"+
			    "flight_julian_date number,"+
			    "year number,"+
			    "header_size number,"+
			    "offset_to_data number,"+
			    "number_variable_length_records number,"+
			    "point_data_format_id number,"+
			    "point_data_record_length number,"+
			    "number_of_point_records number,"+
			    "number_of_points_by_return_1 number,"+
			    "number_of_points_by_return_2 number,"+
			    "number_of_points_by_return_3 number,"+
			    "number_of_points_by_return_4 number,"+
			    "number_of_points_by_return_5 number,"+
			    "x_scale_factor number,"+
			    "y_scale_factor number,"+
			    "z_scale_factor number,"+
			    "x_offset number,"+
			    "y_offset number,"+
			    "z_offset number,"+
			    "max_x number,"+
			    "min_x number,"+
			    "max_y number,"+
			    "min_y number,"+
			    "max_z number,"+
			    "min_z number,"+
			    //"variable_length_records variable_length_record_table,"+
			    //"point_data_records point_data_record_table,"+
			    "extra_data blob "+//"extra_data blob, "+
          //"constraint lidar_data_tab_pk primary key (id)"+
			    ")"+
			    ((tableTableSpace != null)?(" TABLESPACE "+ tableTableSpace +" "):(""))+
			    //"nested table point_data_records store as pdrt_"+ tableName +", "+
			    //"nested table variable_length_records store as vlrt_"+ tableName + 
          " nologging"
          );
	}

  public void createTable_vlr(Connection connection) throws Exception {
    Statement statement = connection.createStatement();
    statement.execute("create table variable_length_records("+
    "vlr_id number,"+
    "fk_id number,"+
    "record_signature number,"+
    "user_id varchar(16),"+
    "record_id number,"+
    "record_length_after_header number,"+
    "description varchar2(32),"+
    "data blob"+
    ")"+ 
    ((tableTableSpace != null)?(" TABLESPACE "+ tableTableSpace +" "):(""))+
    " nologging"
    );
    
    // Add constraints
    //statement.execute( 
    //"alter table " +
    //"variable_length_records "+
    //" add CONSTRAINT vlr_id_fk " +
    //" FOREIGN KEY (fk_id) " +
    //" REFERENCES " +
    //tableName + "(id) " +
    //" novalidate ");

    
  }

  public void createTable_pdr(Connection connection) throws Exception {
    Statement statement = connection.createStatement();
    statement.execute("create table point_data_records("+
    "pdr_id number,"+
    "fk_id number,"+
    "point_geometry sdo_geometry,"+
    "pulse_number number,"+
    "x number,"+
    "y number,"+
    "z number,"+
    "intensity number,"+
    "return_number number,"+
    "number_of_returns number,"+
    "scan_direction_flag number,"+
    "edge_of_flight_line number,"+
    "classification number,"+
    "scan_angle_rank number,"+
    "file_marker number,"+
    "user_bit_field number,"+
    "gps_time number,"+
    "extra_data blob"+
    ")"+
    ((tableTableSpace != null)?(" TABLESPACE "+ tableTableSpace +" "):(""))+
    " nologging"
    );

    // Add constraints
    //statement.execute( 
    //"alter table " +
    //"point_data_records "+
    //" add CONSTRAINT pdr_id_fk " +
    //" FOREIGN KEY (fk_id) " +
    //" REFERENCES " +
    //tableName + "(id) " +
    //" novalidate ");
    

  }

	public void index(Connection connection) throws Exception {
  	  double maxX=0;
	  double minX=0;
	  double maxY=0;
	  double minY=0;
	  double maxZ=0;
	  double minZ=0;
	  double resolutionX=0;
	  double resolutionY=0;
	  double resolutionZ=0;
	  Statement stmt = connection.createStatement();
	  ResultSet boundarySQLResult;
	  boundarySQLResult = 
          stmt.executeQuery("select MAX(max_x),MIN(min_x),MAX(max_y),MIN(min_y)," +
          "MAX(max_z),MIN(min_z),MIN(x_scale_factor),MIN(y_scale_factor),MIN(z_scale_factor) from "+tableName);
	  if (boundarySQLResult.next()) {
	    maxX=boundarySQLResult.getDouble(1);
	    minX=boundarySQLResult.getDouble(2);
	    maxY=boundarySQLResult.getDouble(3);
	    minY=boundarySQLResult.getDouble(4);
	    maxZ=boundarySQLResult.getDouble(5);
	    minZ=boundarySQLResult.getDouble(6);
	    resolutionX=boundarySQLResult.getDouble(7)/2.0;
	    resolutionY=boundarySQLResult.getDouble(8)/2.0;
	    resolutionZ=boundarySQLResult.getDouble(9)/2.0;
	  }
          else {
            System.out.println("No table");
	    return;
	  }

	  stmt.execute("delete from user_sdo_geom_metadata where UPPER(table_name)=UPPER('"+tableName+"')");
	  stmt.execute("insert into user_sdo_geom_metadata values("+
			    "'"+ tableName +"',"+
			    "'coverage_geometry',"+
			    "sdo_dim_array("+
			    "sdo_dim_element('X',"+minX+","+maxX+","+resolutionX+"),"+
			    "sdo_dim_element('Y',"+minY+","+maxY+","+resolutionY+")"+
			    "),"+
			    srid+
			    ")"
          );
	  stmt.execute("drop index is_"+ tableName);
	  stmt.execute("create index is_"+ tableName +" on "+ tableName +
          "(coverage_geometry) indextype is mdsys.spatial_index "+
          "parameters ('SDO_RTR_PCTFREE=5"+((indexTableSpace!=null)?",TABLESPACE="+
          indexTableSpace:"")+",SDO_DML_BATCH_SIZE=5000"+
          ((indexWorkTableSpace != null)?",WORK_TABLESPACE="+ indexWorkTableSpace:"")+"')");

	  stmt.execute("delete from user_sdo_geom_metadata where UPPER(table_name)=UPPER('pdrt_"+tableName+"')");
	  stmt.execute("insert into user_sdo_geom_metadata values("+
			    "'pdrt_"+ tableName +"',"+
			    "'point_geometry',"+
			    "sdo_dim_array("+
			    "sdo_dim_element('X',"+ minX +","+ maxX +","+ resolutionX +"),"+
			    "sdo_dim_element('Y',"+ minY +","+ maxY +","+ resolutionY +"),"+
			    "sdo_dim_element('Z',"+ minZ +","+ maxZ +","+ resolutionZ +")"+
			    "),"+
			    srid +
			    ")"
	  );

	  stmt.execute("drop index is_pdrt_"+ tableName);
	  stmt.execute("create index is_pdrt_"+ tableName +" on pdrt_"+ tableName +
          "(point_geometry) indextype is mdsys.spatial_index "+
          "parameters ('SDO_RTR_PCTFREE=5,LAYER_GTYPE=POINT"+
          ((indexTableSpace!=null)?",TABLESPACE="+indexTableSpace:"")+
          ",SDO_DML_BATCH_SIZE=5000"+((indexWorkTableSpace != null)?",WORK_TABLESPACE="
          + indexWorkTableSpace:"")+"')");

	  stmt.execute("drop index is_pdrt_"+ tableName +"_pn");
	  stmt.execute("create index i_pdrt_"+ tableName +"_pn on pdrt_"+
          tableName+"(pulse_number) "+((indexTableSpace != null)?" TABLESPACE "+
          indexTableSpace:""));
	  stmt.execute("drop index is_pdrt_"+ tableName +"_rn");
	  stmt.execute("create index i_pdrt_"+ tableName +"_rn on pdrt_"+
          tableName +"(return_number) "+((indexTableSpace != null)?" TABLESPACE "+
          indexTableSpace:""));
	}

	public void close(){
          try {
	    bufferin.close();
	    inputStream.close();
	  }
          catch (IOException exception) {
	    exception.printStackTrace();
          }
	}
}
